% Function to draw the snowflakes throughout the array
function model = draw_snowflakes_hexagon(geom, model, workplane)

x_cen = geom.mech.amech/2;
y_cen = 0;
[snowflake_cen_x, snowflake_cen_y] = coordinates_round_snowflake_comsol(x_cen, y_cen, geom.mech.r, geom.mech.w, geom.mech.rad_curv, geom.mech.rad_curv2, geom.mech.resolution);

mech = workplane.geom.create('pol2', 'Polygon');
mech.set('source', 'table');
for pol_i=1:length(snowflake_cen_x(1:end-1))
    mech.setIndex('table', num2str(snowflake_cen_x(pol_i),'%10.9e'), pol_i-1, 0);  %value,row, coloumn
    mech.setIndex('table', num2str(snowflake_cen_y(pol_i),'%10.9e'), pol_i-1, 1);
end

copy = workplane.geom.create('cp_sf_1', 'Copy');
copy.selection('input').set({'pol2'});
copy.set('displx', num2str(-geom.mech.amech,'%10.9e'));

copy = workplane.geom.create('cp_sf_2', 'Copy');
copy.selection('input').set({'pol2'});
copy.set('displx', num2str(-geom.mech.amech/2,'%10.9e'));
copy.set('disply', num2str(geom.mech.amech*sqrt(3)/2,'%10.9e'));

for i=1:geom.stack.num_domy
    copy = workplane.geom.create(strcat('arr1_', num2str(i)), 'Copy');
    copy.selection('input').set({'pol2'});
    copy.set('displx', num2str(-3/2*geom.mech.amech*i,'%10.9e'));
    copy.set('disply', num2str(geom.mech.amech*sqrt(3)/2*i,'%10.9e'));
    
    inp_arr1(i) = strcat('arr1_', {num2str(i)});
end

uni = workplane.geom.create('arr1', 'Union');
uni.selection('input').set(inp_arr1);

for i=1:geom.stack.num_domy-1
    copy = workplane.geom.create(strcat('arr2_', num2str(i)), 'Copy');
    copy.selection('input').set({'cp_sf_1' 'cp_sf_2'});
    copy.set('displx', num2str(-3/2*geom.mech.amech*i,'%10.9e'));
    copy.set('disply', num2str(geom.mech.amech*sqrt(3)/2*i,'%10.9e'));
    
    inp_arr2(i) = strcat('arr2_', {num2str(i)});
end

uni = workplane.geom.create('arr2', 'Union');
uni.selection('input').set(inp_arr2);

uni = workplane.geom.create('uni_snowflakes', 'Union');
uni.selection('input').set({'pol2' 'cp_sf_1' 'cp_sf_2' 'arr1' 'arr2'});

end